//=============================================================================
// xmas UT_jumpBoots
//=============================================================================
class xmasJumpBoots extends UT_JumpBoots config;

#exec TEXTURE IMPORT NAME=xmasJump FILE=Textures\xmasJump.bmp LODSET=2
#exec AUDIO IMPORT FILE="Sounds\xmasJumpSnd.WAV" NAME="xmasJumpSnd"


var config bool bPowerJump; 	// True=jump higher
var config bool bInsaneJump;	// True=jump insanely high (requires bPowerJump=True)
var int JumpHight;
var int TimeCharge;

//var localized int Charge, RespawnTime;



function PickupFunction(Pawn Other)
{
	TimeCharge = 0;
	SetTimer(1.0, True);
}

function ResetOwner()
{
	local pawn P;
	
	P = Pawn(Owner);
	P.JumpZ = P.Default.JumpZ * Level.Game.PlayerJumpZScaling();
	if ( Level.Game.IsA('DeathMatchPlus') )
		P.AirControl = DeathMatchPlus(Level.Game).AirControl;
	else
		P.AirControl = P.Default.AirControl;
	P.bCountJumps = False;
}

function OwnerJumped()
{
	if ( !Pawn(Owner).bIsWalking )
	{
		TimeCharge=0;
		if ( Charge <= 0 ) 
		{
			if ( Owner != None )
			{
				Owner.PlaySound(DeActivateSound);
				ResetOwner();						
			}		
			UsedUp();
		}
		else
			Owner.PlaySound(sound'BootJmp');						
		Charge -= 1;
	}
	if( Inventory != None )
		Inventory.OwnerJumped();

}

function Timer()
{
	if ( Charge <= 0 ) 
	{
		if ( Owner != None )
		{
			if ( Owner.Physics == PHYS_Falling )
			{
				SetTimer(0.3, true);
				return;
			}
			Owner.PlaySound(DeActivateSound);
			ResetOwner();						
		}		
		UsedUp();
		return;
	}

	if ( !Pawn(Owner).bAutoActivate )
	{	
		TimeCharge++;
		if (TimeCharge>20)
		{
			OwnerJumped();
			TimeCharge = 0;
		}
	}
}

state Activated
{
	function endstate()
	{
		ResetOwner();
		bActive = false;		
	}
Begin:
	if ( bPowerJump )
		{
		if ( bInsaneJump )
			{
			JumpHight = 8;
			}
		else
			{
			JumpHight = 5;
			}
		}
	else
		{
		JumpHight = 3;
		}
	Pawn(Owner).bCountJumps = True;
	Pawn(Owner).AirControl = 1.0;
	Pawn(Owner).JumpZ = Pawn(Owner).Default.JumpZ * JumpHight; //3
	Owner.PlaySound(ActivateSound);		
}

state DeActivated
{
Begin:		
}

defaultproperties
{
     bPowerJump=True
     ExpireMessage="Santas Boots have drained."
     PickupMessage="You picked up Santas boots."
     ItemName="Xmas AntiGrav Boots"
     PickupSound=Sound'DanesXmas_v2009.xmasJumpSnd'
     ActivateSound=Sound'DanesXmas_v2009.xmasJumpSnd'
     MultiSkins(1)=Texture'DanesXmas_v2009.xmasJump'
}
